import pickle
import sys
#sys.path.insert(1, '/Users/jdnweltz/Documents/virtualenv/BayesXY/lib/python3.9/site-packages')
import os
import seaborn as sns
import numpy as np
from numpy import random as rand
import matplotlib.pyplot as plt
import time
import functools, multiprocessing
import pandas as pd
from algorithms import AdaptiveXY
from identifiable import MVT_arms_identif

def BAIexperiment(theta, X, Z, Sigma, MVT =False):
    arm, _, t_rage_hetero = AdaptiveXY (theta, X, Z, Sigma, True, False, 0.05, False, MVT = MVT)
    print(arm)
    print(t_rage_hetero)
    arm, _, t_rage = AdaptiveXY (theta, X, Z, Sigma, False, False, 0.05, False, MVT = MVT)
    print(arm)
    print(t_rage)
    arm, _, t_oracle_hetero = AdaptiveXY (theta, X, Z, Sigma, True, True, 0.05, False, MVT = MVT)
    print(arm)
    print(t_oracle_hetero)
    arm, _, t_oracle = AdaptiveXY(theta, X, Z, Sigma, False, True, 0.05, False, MVT = MVT)
    print(arm)
    print(t_oracle)
        
    return(np.array([t_rage_hetero, t_rage, t_oracle_hetero, t_oracle]))




def simulate(sim):
    np.random.seed()
    
    #Experiment 1
    print("Experiment 1")
    omega = 1
    alpha = 1
    beta = 1
    gamma = 1
    upsilon = 1
    X = np.array([[1, 0, 0, 0],
                  [np.cos(np.radians(omega)), np.sin(np.radians(omega)), 0, 0],
                  [np.cos(np.radians(omega)), 0, np.sin(np.radians(omega)), 0],
                  [np.cos(np.radians(omega)), 0, 0, np.sin(np.radians(omega))],
                  [np.cos(np.radians(omega)), np.sin(np.radians(omega)), 0, 0],
                  [0.5,0.5,0.1, 0.1], 
                  [0.5,0.5,0.1, 0],
                  [0,0,0.4, 0],
                  [0,1,0, 0], 
                  [0,0,0,0.4]
                 ])
    n = X.shape[0]
    theta = [1,0,0, 0]
    Sigma = np.array([[alpha,0,0,0], [0, beta, 0, 0], [0, 0, gamma, 0], [0, 0, 0, upsilon]])

    Results_1 = BAIexperiment(theta, X, X.copy(), Sigma)

    df_1 = pd.DataFrame([Results_1], columns = ['Rage Hetero','Rage','Oracle Hetero', 'Oracle'])
    df_1['Experiment'] = "Experiment1"
    df_1["Sim"] = sim
    
    
    #Experiment 2
    print("Experiment 2")
    omega = 1
    alpha = 1
    beta = 0.2
    gamma = 0.2
    theta = [1,0,0]
    X = np.array([[1,0,0],[np.cos(np.radians(omega)), np.sin(np.radians(omega)), 0],
                  [np.sqrt(1/2),np.sqrt(1/2),0], [0,np.sqrt(1/2),np.sqrt(1/2)], 
                  [0,0,1], [np.sqrt(1/2),0,np.sqrt(1/2)]
                 ])
    Sigma = np.array([[alpha,0, 0], [0, beta, 0], [0, 0, gamma]])

    Results_2 = BAIexperiment(theta, X, X.copy(), Sigma)

    df_2 = pd.DataFrame([Results_2], columns = ['Rage Hetero','Rage','Oracle Hetero', 'Oracle'])
    df_2['Experiment'] = "Experiment2"
    df_2["Sim"] = sim
    
    
    #MVT Experiment
    print("MVT Experiment")
    X = MVT_arms_identif(3,2)
    Z = X.copy()
    n = X.shape[0]
    d = X.shape[1]
    Sigma = np.diag([0.3] + [0.7] + [0.001] + [0.001] + [0.001]*(d-4))
    theta = [0, 0.01, 0.015, 0.02] + [-0.1]*(d-4)
    Results_MVT = BAIexperiment(theta, X, Z, Sigma)

    df_MVT = pd.DataFrame([Results_MVT], columns = ['Rage Hetero','Rage','Oracle Hetero', 'Oracle'])
    df_MVT['Experiment'] = "MVT"
    df_MVT["Sim"] = sim

    return(pd.concat([df_1, df_2, df_MVT]))
    
    
